package com.jz.gymchina.jar.resources.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.records.UserGroupRecord;

@Lazy
@Repository
public class UserGroupRepository extends ResourceBaseRepository {

	private static com.jz.jooq.gymchina.resources.tables.UserGroup UG = Tables.USER_GROUP;

	public List<String> getGroupsForUser(String uid) {
		return resourcesCtx.select(UG.GID).from(UG).where(UG.UID.eq(uid)).fetchInto(String.class);
	}

	public void clearGroups(String uid) {
		resourcesCtx.deleteFrom(UG).where(UG.UID.eq(uid)).execute();
	}

	public void refreshGroups(String uid, Collection<String> gids) {
		List<UserGroupRecord> records = Lists.newArrayList();
		for (String gid : gids) {
			records.add(new UserGroupRecord(uid, gid));
		}
		resourcesCtx.batchInsert(records).execute();
	}
}
