/*
 * Decompiled with CFR 0.152.
 */
package com.jz.gymchina.jar.resources.repository;

import com.google.common.collect.Lists;
import com.jz.gymchina.jar.resources.repository.ResourceBaseRepository;
import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.GroupDir;
import com.jz.jooq.gymchina.resources.tables.records.GroupDirRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class GroupDirectoryRepository
extends ResourceBaseRepository {
    private static GroupDir GD = Tables.GROUP_DIR;

    public List<com.jz.jooq.gymchina.resources.tables.pojos.GroupDir> getGroupDirectories() {
        return this.resourcesCtx.selectFrom((Table)GD).fetchInto(com.jz.jooq.gymchina.resources.tables.pojos.GroupDir.class);
    }

    public void clearDirectoriesInfo(String gid) {
        this.resourcesCtx.deleteFrom((Table)GD).where(new Condition[]{GroupDirectoryRepository.GD.GID.eq((Object)gid)}).execute();
    }

    public void refreshGroupDirectories(String gid, Collection<String> dirs) {
        ArrayList records = Lists.newArrayList();
        for (String dir : dirs) {
            records.add(new GroupDirRecord(gid, dir));
        }
        this.resourcesCtx.batchInsert((Collection)records).execute();
    }

    public List<String> getDirectories(String gid) {
        return this.resourcesCtx.select((SelectField)GroupDirectoryRepository.GD.DIR_ID).from((TableLike)GD).where(new Condition[]{GroupDirectoryRepository.GD.GID.eq((Object)gid)}).fetchInto(String.class);
    }
}

