/*
 * Decompiled with CFR 0.152.
 */
package com.jz.gymchina.jar.resources.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.gymchina.jar.resources.extend.GymUserInfoJoinUserGroup;
import com.jz.gymchina.jar.resources.repository.ResourceBaseRepository;
import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.UserGroup;
import com.jz.jooq.gymchina.resources.tables.pojos.GymUserInfo;
import com.jz.jooq.gymchina.resources.tables.records.GymUserInfoRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class GymUserInfoRepository
extends ResourceBaseRepository {
    private static com.jz.jooq.gymchina.resources.tables.GymUserInfo UI = Tables.GYM_USER_INFO;
    private static UserGroup UG = Tables.USER_GROUP;

    public boolean existUsername(String username) {
        return this.resourcesCtx.fetchExists((Table)UI, GymUserInfoRepository.UI.USERNAME.eq((Object)username));
    }

    public GymUserInfo getUserForLogin(String username, String password) {
        return (GymUserInfo)this.resourcesCtx.select((SelectField)GymUserInfoRepository.UI.UID, (SelectField)GymUserInfoRepository.UI.USERNAME, (SelectField)GymUserInfoRepository.UI.NICKNAME, (SelectField)GymUserInfoRepository.UI.ENABLE, (SelectField)GymUserInfoRepository.UI.IS_ADMIN).from((TableLike)UI).where(new Condition[]{GymUserInfoRepository.UI.USERNAME.eq((Object)username).and(GymUserInfoRepository.UI.PASSWORD.eq((Object)password))}).fetchAnyInto(GymUserInfo.class);
    }

    public GymUserInfo getUser(String uid) {
        return (GymUserInfo)this.resourcesCtx.selectFrom((Table)UI).where(new Condition[]{GymUserInfoRepository.UI.UID.eq((Object)uid)}).fetchAnyInto(GymUserInfo.class);
    }

    public void addUserInfo(String uid, String username, String password, String nickname, String email) {
        GymUserInfoRecord userInfo = new GymUserInfoRecord();
        userInfo.setUid(uid);
        userInfo.setUsername(username);
        userInfo.setPassword(password);
        userInfo.setNickname(nickname);
        userInfo.setEmail(email);
        userInfo.setIsAdmin(Integer.valueOf(0));
        userInfo.setLastUpdate(Long.valueOf(System.currentTimeMillis()));
        userInfo.setEnable(Integer.valueOf(1));
        this.resourcesCtx.insertInto((Table)UI).set((Record)userInfo).execute();
    }

    public void updatePassword(String uid, String password) {
        this.resourcesCtx.update((Table)UI).set((Field)GymUserInfoRepository.UI.PASSWORD, (Object)password).set((Field)GymUserInfoRepository.UI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{GymUserInfoRepository.UI.UID.eq((Object)uid)}).execute();
    }

    public void updateUserInfo(String uid, String nickname, String email) {
        UpdateSetMoreStep moreStep = this.resourcesCtx.update((Table)UI).set((Field)GymUserInfoRepository.UI.LAST_UPDATE, (Object)System.currentTimeMillis());
        if (StringTools.isNotEmptyAndBlank((String)nickname)) {
            moreStep = moreStep.set((Field)GymUserInfoRepository.UI.NICKNAME, (Object)nickname);
        }
        if (StringTools.isNotEmptyAndBlank((String)email)) {
            moreStep = moreStep.set((Field)GymUserInfoRepository.UI.EMAIL, (Object)email);
        }
        moreStep.where(new Condition[]{GymUserInfoRepository.UI.UID.eq((Object)uid)}).execute();
    }

    public void updateUserEnableInfo(String uid, int enable) {
        this.resourcesCtx.update((Table)UI).set((Field)GymUserInfoRepository.UI.ENABLE, (Object)enable).set((Field)GymUserInfoRepository.UI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{GymUserInfoRepository.UI.UID.eq((Object)uid)}).execute();
    }

    public boolean isAdmin(String uid) {
        return this.resourcesCtx.fetchExists((Table)UI, GymUserInfoRepository.UI.UID.eq((Object)uid).and(GymUserInfoRepository.UI.ENABLE.eq((Object)1)).and(GymUserInfoRepository.UI.IS_ADMIN.eq((Object)1)));
    }

    public List<String> getForbiddenUsers() {
        return this.resourcesCtx.select((SelectField)GymUserInfoRepository.UI.UID).from((TableLike)UI).where(new Condition[]{GymUserInfoRepository.UI.ENABLE.eq((Object)0)}).fetchInto(String.class);
    }

    private TableOnConditionStep getJoinTables() {
        return UI.leftOuterJoin((TableLike)UG).on(new Condition[]{GymUserInfoRepository.UI.UID.eq((Field)GymUserInfoRepository.UG.UID)});
    }

    private Condition getWhereCondition(String name, Integer enable, Collection<String> gids) {
        Condition condition = DSL.trueCondition();
        if (StringTools.isNotEmptyAndBlank((String)name)) {
            condition = condition.and(DSL.or((Condition[])new Condition[]{GymUserInfoRepository.UI.USERNAME.like("%" + name + "%"), GymUserInfoRepository.UI.NICKNAME.like("%" + name + "%")}));
        }
        if (null != enable) {
            condition = condition.and(GymUserInfoRepository.UI.ENABLE.eq((Object)enable));
        }
        if (ArrayMapTools.isNotEmpty(gids)) {
            condition = condition.and(GymUserInfoRepository.UG.GID.in(gids));
        }
        return condition;
    }

    public int countUsers(String name, Integer enable, Collection<String> gids) {
        return this.resourcesCtx.fetchCount((Select)this.resourcesCtx.select((SelectField)GymUserInfoRepository.UI.UID).from((TableLike)this.getJoinTables()).where(new Condition[]{this.getWhereCondition(name, enable, gids)}).groupBy(new GroupField[]{GymUserInfoRepository.UI.UID}));
    }

    public List<GymUserInfoJoinUserGroup> getUsers(String name, Integer enable, Collection<String> gids, int start, int size) {
        return this.resourcesCtx.select((SelectField)GymUserInfoRepository.UI.UID, (SelectField)GymUserInfoRepository.UI.USERNAME, (SelectField)GymUserInfoRepository.UI.NICKNAME, (SelectField)GymUserInfoRepository.UI.EMAIL, (SelectField)GymUserInfoRepository.UI.ENABLE, (SelectField)GymUserInfoRepository.UI.IS_ADMIN, (SelectField)DSL.groupConcat((Field)GymUserInfoRepository.UG.GID).as("gids")).from((TableLike)this.getJoinTables()).where(new Condition[]{this.getWhereCondition(name, enable, gids)}).groupBy(new GroupField[]{GymUserInfoRepository.UI.UID}).orderBy(GymUserInfoRepository.UI.LAST_UPDATE.desc()).limit(start, size).fetchInto(GymUserInfoJoinUserGroup.class);
    }
}

