package com.jz.gymchina.jar.resources.repository;

import java.util.List;

import org.jooq.InsertValuesStep2;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.pojos.GroupDir;
import com.jz.jooq.gymchina.resources.tables.records.GroupDirRecord;

@Lazy
@Repository
public class GroupDirectoryRepository extends ResourceBaseRepository {

	private static com.jz.jooq.gymchina.resources.tables.GroupDir GD = Tables.GROUP_DIR;

	public List<GroupDir> getGroupDirectories() {
		return resourcesCtx.selectFrom(GD).fetchInto(GroupDir.class);
	}

	public void clearDirectoriesInfo(String gid) {
		resourcesCtx.deleteFrom(GD).where(GD.GID.eq(gid)).execute();
	}

	public void refreshGroupDirectories(String gid, List<String> dirs) {
		InsertValuesStep2<GroupDirRecord, String, String> values = resourcesCtx.insertInto(GD, GD.GID, GD.DIR_ID);
		for (String dir : dirs) {
			values = values.values(gid, dir);
		}
		values.onDuplicateKeyIgnore().execute();
	}

	public List<String> getDirectories(String gid) {
		return resourcesCtx.select(GD.DIR_ID).from(GD).where(GD.GID.eq(gid)).fetchInto(String.class);
	}
}
