package com.jz.gymchina.jar.resources.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.pojos.GymUserGroup;

@Lazy
@Repository
public class GymUserGroupRepository extends ResourceBaseRepository {

	private static com.jz.jooq.gymchina.resources.tables.GymUserGroup GUG = Tables.GYM_USER_GROUP;

	public List<GymUserGroup> getUserGroups() {
		return resourcesCtx.select(GUG.UGID, GUG.NAME).from(GUG).orderBy(GUG.SEQ.asc()).fetchInto(GymUserGroup.class);
	}

	public List<GymUserGroup> getUserGroups(Collection<String> ids) {
		return resourcesCtx.select(GUG.UGID, GUG.NAME).from(GUG).where(GUG.UGID.in(ids)).orderBy(GUG.SEQ.asc())
				.fetchInto(GymUserGroup.class);
	}

}
