package com.jz.gymchina.jar.resources.cache.ram;

import java.util.List;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.gymchina.jar.resources.service.GymUserInfoService;

@Lazy
@Component
public class RAMUserCache {

	@Autowired
	private GymUserInfoService gymUserInfoService;

	private static final List<String> forbiddenUsers = Lists.newArrayList();

	@PostConstruct
	public void refreshCacheInfo() {
		List<String> tempForbiddenUsers = gymUserInfoService.getForbiddenUsers();
		forbiddenUsers.clear();
		if (ArrayMapTools.isEmpty(tempForbiddenUsers))
			return;
		forbiddenUsers.addAll(tempForbiddenUsers);
	}

	public boolean isForbidden(String uid) {
		return forbiddenUsers.contains(uid);
	}

}
