package com.jz.gymchina.jar.resources.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.gymchina.jar.resources.repository.TransCodeRepository;

@Lazy
@Service
public class TransCodeService {

	@Autowired
	private TransCodeRepository transCodeRepository;

	public void refreshTransCode(String jobId, String fileId) {
		transCodeRepository.refreshTransCode(jobId, fileId);
	}

	public boolean isExistTransCode(String jobId) {
		return transCodeRepository.isExistTransCode(jobId);
	}

	public String getFileId(String jobId) {
		return transCodeRepository.getFileId(jobId);
	}

	public void deleteFile(String jobId) {
		transCodeRepository.deleteFile(jobId);
	}

}
