package com.jz.gymchina.jar.resources.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.gymchina.jar.resources.repository.DirectoryRepository;
import com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory;

/**
 * @Title DirectoryService
 * @Package org.gymchina.resources.service
 * @author tangjunfeng
 * @date 2019年3月11日 下午2:16:57
 * @version V1.0
 */
@Lazy
@Service
public class DirectoryService {

	@Autowired
	private DirectoryRepository directoryRepository;

	public List<GymDirectory> getOnlineDirectories(boolean isShowName) {
		return directoryRepository.getOnlineDirectories(isShowName);
	}

	public int countChildrenDirectories(String dirId) {
		return directoryRepository.countChildrenDirectories(dirId);
	}

	public List<GymDirectory> getChildrenDirectories(String dirId) {
		return directoryRepository.getChildrenDirectories(dirId);
	}

	public boolean existDirectory(String dirId) {
		return directoryRepository.existDirectory(dirId);
	}

	public int countExistDirectory(Collection<String> dirIds) {
		return directoryRepository.countExistDirectory(dirIds);
	}

	public GymDirectory getDirectory(String dirId) {
		return directoryRepository.getDirectory(dirId);
	}

	public List<GymDirectory> getDirectories(Collection<String> dirIds) {
		return directoryRepository.getDirectories(dirIds);
	}

	public Integer getDirectoryRank(String dirId) {
		return directoryRepository.getDirectoryRank(dirId);
	}

	public void addDirectory(String dirId, String name, GymDirectory parentDir, String uid) {
		directoryRepository.addDirectory(dirId, name, parentDir, uid);
	}

	public void updateDirectoryName(String dirId, String name, String uid) {
		directoryRepository.updateDirectoryName(dirId, name, uid);
	}

	public void deleteDirectory(String dirId, String uid) {
		directoryRepository.deleteDirectory(dirId, uid);
	}

	public void batchInsertDirectories(Collection<GymDirectory> dirRecords) {
		directoryRepository.batchInsertDirectories(dirRecords);
	}

	public String getDirectoryRoot(String dirId) {
		return directoryRepository.getDirectoryRoot(dirId);
	}

	public List<GymDirectory> getDirectoryRoot(Collection<String> dirIds) {
		return directoryRepository.getDirectoryRoot(dirIds);
	}
}
