package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SortField;
import org.jooq.TableOnConditionStep;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jar.franchise.wrapper.LessonExtendWrapper;
import com.jz.jooq.franchise.Tables;

/**
 * @Title FranchiseMultiTableJoinRepository
 * @Package com.jz.jar.franchise.repository
 * @author tangjunfeng
 * @date 2019年1月17日 上午10:12:31
 * @version V1.0
 */
@Lazy
@Repository
public class FranchiseMultiTableJoinRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.Lesson LE = Tables.LESSON;
	private static final com.jz.jooq.franchise.tables.LessonStudent LS = Tables.LESSON_STUDENT;

	private TableOnConditionStep getLessonJoinLessonStudent() {
		return LS.join(LE).on(LS.SCHOOL_ID.eq(LE.SCHOOL_ID).and(LS.LESSON_ID.eq(LE.LESSON_ID)));
	}

	private Condition getCondition(Collection<String> schoolIds, String suid, Collection<Integer> statuses) {
		return LS.SCHOOL_ID.in(schoolIds).and(LS.SUID.eq(suid)).and(LS.STATUS.in(statuses));
	}

	public int countLessonForStudentStatus(Collection<String> schoolIds, String suid, Collection<Integer> statuses) {
		return franchiseCtx.fetchCount(getLessonJoinLessonStudent(), getCondition(schoolIds, suid, statuses));
	}

	public List<LessonExtendWrapper> findLessonForStudentStatus(Collection<String> schoolIds, String suid,
			Collection<Integer> statuses, boolean asc, int start, int size) {
		SortField<Long> sortField = asc ? LE.START_TIME.asc() : LE.START_TIME.desc();
		// lesson all fields
		List<Field<?>> resultFields = Lists.newArrayList(LE.fields());
		// lesson student fields
		resultFields.add(LS.CONTRACT_ID);
		return franchiseCtx.select(resultFields).from(getLessonJoinLessonStudent())
				.where(getCondition(schoolIds, suid, statuses)).orderBy(sortField).limit(start, size)
				.fetchInto(LessonExtendWrapper.class);
	}
}
