/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.School;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class SchoolRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.School SC = Tables.SCHOOL;

    public School getSchool(String id) {
        return (School)this.franchiseCtx.selectFrom((Table)SC).where(new Condition[]{SchoolRepository.SC.ID.eq((Object)id).and(SchoolRepository.SC.STATUS.eq((Object)1))}).fetchAnyInto(School.class);
    }

    public List<School> getSimpleSchool(Collection<String> ids) {
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.ID, (SelectField)SchoolRepository.SC.CENTER_NAME, (SelectField)SchoolRepository.SC.CENTER_ADDRESS, (SelectField)SchoolRepository.SC.PHONE).from((TableLike)SC).where(new Condition[]{SchoolRepository.SC.ID.in(ids).and(SchoolRepository.SC.STATUS.eq((Object)1))}).fetchInto(School.class);
    }

    public List<School> getSchools(String brand, String prov, String city) {
        Condition condition = SchoolRepository.SC.BRAND_ID.eq((Object)brand).and(SchoolRepository.SC.PROV.eq((Object)prov)).and(SchoolRepository.SC.STATUS.eq((Object)1)).and(SchoolRepository.SC.CODE.ge((Object)100));
        if (StringTools.isNotEmpty((CharSequence)city)) {
            condition = condition.and(SchoolRepository.SC.CITY.eq((Object)city));
        }
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.ID, (SelectField)SchoolRepository.SC.CENTER_NAME, (SelectField)SchoolRepository.SC.CENTER_ADDRESS, (SelectField)SchoolRepository.SC.PHONE).from((TableLike)SC).where(new Condition[]{condition}).orderBy(SchoolRepository.SC.CODE.desc()).fetchInto(School.class);
    }

    public String getSchoolName(String id) {
        return (String)this.franchiseCtx.select((SelectField)SchoolRepository.SC.CENTER_NAME).from((TableLike)SC).where(new Condition[]{SchoolRepository.SC.ID.eq((Object)id).and(SchoolRepository.SC.STATUS.eq((Object)1))}).fetchAnyInto(String.class);
    }

    public List<String> getSchoolIdForBrand(String brand) {
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.ID).from((TableLike)SC).where(new Condition[]{SchoolRepository.SC.BRAND_ID.eq((Object)brand).and(SchoolRepository.SC.STATUS.eq((Object)1))}).fetchInto(String.class);
    }
}

