package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CoursePackRepository;
import com.jz.jar.franchise.wrapper.CoursePackWrapper;
import com.jz.jooq.franchise.tables.pojos.CoursePackHo;
import com.jz.jooq.franchise.tables.pojos.CoursePackHoPrice;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchool;
import com.jz.jooq.franchise.tables.pojos.School;

@Lazy
@Service
public class CoursePackService {

	@Autowired
	private CoursePackRepository coursePackRepository;
	@Autowired
	private SchoolService schoolService;

	public List<CoursePackWrapper> getEnableSchoolPacks(String uid, String schoolId) {
		School school = schoolService.getSchool(schoolId);
		if (school == null) {
			return null;
		}
		List<CoursePackWrapper> list = Lists.newArrayList();
		Set<String> disableHoSet = Sets.newHashSet(coursePackRepository.getHoDisable(schoolId));
		List<CoursePackHo> hoPacks = coursePackRepository.getAllCoursePackHo(school.getBrandId());
		if (ArrayMapTools.isNotEmpty(hoPacks)) {
			hoPacks.forEach(it -> {
				if (!disableHoSet.contains(it.getCoursePackId())) {
					list.add(CoursePackWrapper.ofMeta(it));
				}
			});
		}
		List<CoursePackSchool> schoolPacks = coursePackRepository.getEnablePackSchool(schoolId);
		if (ArrayMapTools.isNotEmpty(schoolPacks)) {
			schoolPacks.forEach(it -> {
				list.add(CoursePackWrapper.ofMeta(it));
			});
		}
		return list;
	}

	public List<CoursePackWrapper> getSchoolPacksWithTotalInfos(String uid, String schoolId) {
		School school = schoolService.getSchool(schoolId);
		if (school == null) {
			return null;
		}
		List<CoursePackWrapper> list = Lists.newArrayList();
		List<CoursePackHo> hoPacks = coursePackRepository.getAllCoursePackHo(school.getBrandId());
		if (ArrayMapTools.isNotEmpty(hoPacks)) {
			hoPacks.forEach(it -> {
				list.add(CoursePackWrapper.ofHo(it));
			});
		}
		List<CoursePackSchool> schoolPacks = coursePackRepository.getPackSchool(schoolId);
		if (ArrayMapTools.isNotEmpty(schoolPacks)) {
			schoolPacks.forEach(it -> {
				list.add(CoursePackWrapper.ofSchool(it));
			});
		}
		return list;
	}

	public List<CoursePackWrapper> getEnableSchoolPacksWithPrice(String brandId, String schoolId, int cityLevel) {
		List<CoursePackWrapper> list = Lists.newArrayList();
		List<CoursePackHo> hoPacks = coursePackRepository.getAllCoursePackHo(brandId);
		Set<String> disableHoSet = Sets.newHashSet(coursePackRepository.getHoDisable(schoolId));
		if (ArrayMapTools.isNotEmpty(hoPacks)) {
			List<String> coursePackIds = hoPacks.stream().map(it -> it.getCoursePackId()).collect(Collectors.toList());
			List<CoursePackHoPrice> prices = coursePackRepository.getHoPrices(coursePackIds, cityLevel);
			Map<String, CoursePackHoPrice> priceMap = Maps.newHashMap();
			prices.forEach(it -> {
				priceMap.put(it.getCoursePackId(), it);
			});
			for (CoursePackHo cp : hoPacks) {
				if (disableHoSet.contains(cp.getCoursePackId())) {
					continue;
				}
				CoursePackWrapper wrapper = CoursePackWrapper.ofHo(cp);
				if (!priceMap.containsKey(cp.getCoursePackId())) {
					continue;
				}
				wrapper.setHoPrice(priceMap.get(cp.getCoursePackId()));
				list.add(wrapper);
			}
		}
		List<CoursePackSchool> schoolPacks = coursePackRepository.getEnablePackSchool(schoolId);
		if (ArrayMapTools.isNotEmpty(schoolPacks)) {
			schoolPacks.forEach(cp -> {
				list.add(CoursePackWrapper.ofSchool(cp));
			});
		}
		return list;
	}

	public CoursePackWrapper getCoursePackWrapper(String brandId, String schoolId, String coursePackId, int cityLevel) {
		CoursePackWrapper wrapper = null;
		CoursePackHo hoPack = coursePackRepository.getCoursePackHo(coursePackId);
		if (hoPack != null) {
			wrapper = CoursePackWrapper.ofHo(hoPack);
			CoursePackHoPrice hoPrice = coursePackRepository.getHoPrice(coursePackId, cityLevel);
			wrapper.setHoPrice(hoPrice);
		} else {
			CoursePackSchool schPack = coursePackRepository.getCoursePackSchool(schoolId, coursePackId);
			if (schPack != null) {
				wrapper = CoursePackWrapper.ofSchool(schPack);
			}
		}
		return wrapper;
	}

	public Map<String, CoursePackWrapper> mutiGetSchoolPack(String schoolId, Collection<String> coursePackIds) {
		if (ArrayMapTools.isEmpty(coursePackIds)) {
			return null;
		}
		Map<String, CoursePackWrapper> map = Maps.newHashMap();
		List<CoursePackHo> hoPacks = coursePackRepository.mutiGetCoursePackHo(coursePackIds);
		if (ArrayMapTools.isNotEmpty(hoPacks)) {
			hoPacks.forEach(it -> {
				map.put(it.getCoursePackId(), CoursePackWrapper.ofMeta(it));
			});
		}
		if (coursePackIds.size() == map.size()) {
			return map;
		}
		List<CoursePackSchool> schoolPacks = coursePackRepository.mutiGetPackSchool(schoolId, coursePackIds);
		if (ArrayMapTools.isNotEmpty(schoolPacks)) {
			schoolPacks.forEach(it -> {
				map.put(it.getCoursePackId(), CoursePackWrapper.ofMeta(it));
			});
		}
		return map;
	}

	public Map<String, CoursePackWrapper> mutiGetSchoolPackWithPackDetail(String schoolId,
			Collection<String> coursePackIds) {
		if (ArrayMapTools.isEmpty(coursePackIds)) {
			return null;
		}
		Map<String, CoursePackWrapper> map = Maps.newHashMap();
		List<CoursePackHo> hoPacks = coursePackRepository.mutiGetCoursePackHo(coursePackIds);
		if (ArrayMapTools.isNotEmpty(hoPacks)) {
			hoPacks.forEach(it -> {
				map.put(it.getCoursePackId(), CoursePackWrapper.ofHo(it));
			});
		}
		if (coursePackIds.size() == map.size()) {
			return map;
		}
		List<CoursePackSchool> schoolPacks = coursePackRepository.mutiGetPackSchool(schoolId, coursePackIds);
		if (ArrayMapTools.isNotEmpty(schoolPacks)) {
			schoolPacks.forEach(it -> {
				map.put(it.getCoursePackId(), CoursePackWrapper.ofSchool(it));
			});
		}
		return map;
	}

	public List<String> getPackIdsByCourseId(String schoolId, int courseId) {
		School school = schoolService.getSchool(schoolId);
		if (school == null) {
			return null;
		}
		List<String> packIds = Lists.newArrayList();
		packIds.addAll(coursePackRepository.getHoPackIdsByCourseId(school.getBrandId(), courseId));
		packIds.addAll(coursePackRepository.getSchoolPackIdsByCourseId(schoolId, courseId));
		return packIds;
	}

	public List<Integer> getCoursesByPackId(String brandId, String schoolId, String coursePackId) {
		List<Integer> courseIds = coursePackRepository.getHoCourseIds(brandId, coursePackId);
		if (ArrayMapTools.isEmpty(courseIds)) {
			courseIds = coursePackRepository.getSchoolCourseIds(schoolId, coursePackId);
		}
		return courseIds;
	}

}
