package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.School;

@Lazy
@Repository
public class SchoolRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.School SC = Tables.SCHOOL;

	public School getSchool(String id) {
		return franchiseCtx.selectFrom(SC).where(SC.ID.eq(id).and(SC.STATUS.eq(1))).fetchAnyInto(School.class);
	}

	public List<School> getSimpleSchool(Collection<String> ids) {
		return franchiseCtx.select(SC.ID, SC.CENTER_NAME, SC.CENTER_ADDRESS, SC.PHONE).from(SC)
				.where(SC.ID.in(ids).and(SC.STATUS.eq(1))).fetchInto(School.class);
	}

	public List<School> getSchools(String brand, String prov, String city) {
		// 预约的学校只展示 code >= 100 的学校
		Condition condition = SC.BRAND_ID.eq(brand).and(SC.PROV.eq(prov)).and(SC.STATUS.eq(1)).and(SC.CODE.ge(100));
		if (StringTools.isNotEmpty(city))
			condition = condition.and(SC.CITY.eq(city));
		return franchiseCtx.select(SC.ID, SC.CENTER_NAME, SC.CENTER_ADDRESS, SC.PHONE).from(SC).where(condition)
				.orderBy(SC.CODE.desc()).fetchInto(School.class);
	}

	public String getSchoolName(String id) {
		return franchiseCtx.select(SC.CENTER_NAME).from(SC).where(SC.ID.eq(id).and(SC.STATUS.eq(1)))
				.fetchAnyInto(String.class);
	}

	public List<String> getSchoolIdForBrand(String brand) {
		return franchiseCtx.select(SC.ID).from(SC).where(SC.BRAND_ID.eq(brand).and(SC.STATUS.eq(1)))
				.fetchInto(String.class);
	}
}
