package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.StudentSchoolContract;
import com.jz.jooq.franchise.tables.records.StudentSchoolContractRecord;

@Lazy
@Repository
public class StudentSchoolContractRepository extends FranchiseBaseRepository implements
		FranchiseConditionRepository<StudentSchoolContractRecord> {

	private static final com.jz.jooq.franchise.tables.StudentSchoolContract SSC = Tables.STUDENT_SCHOOL_CONTRACT;

	public Pair<Integer, Integer> getLessionCount(String suid) {
		List<Map<String, Object>> maps = franchiseCtx
				.select(DSL.sum(SSC.TOTAL_OFFICAL_LESSON).as("total"),
						DSL.sum(SSC.CONSUME_OFFICAL_LESSON).as("consume")).from(SSC)
				.where(SSC.SUID.eq(suid).and(SSC.STATUS.ne(-1))).fetchMaps();
		if (ArrayMapTools.isEmpty(maps))
			return Pair.of(0, 0);
		Map<String, Object> has = maps.get(0);
		if (ArrayMapTools.isEmpty(has) || !ArrayMapTools.containsKeys(has, "total", "consume"))
			return Pair.of(0, 0);
		return Pair.of(ArrayMapTools.getInteger(has, "total", 0), ArrayMapTools.getInteger(has, "consume", 0));
	}

	public Map<String, Pair<Integer, Integer>> getLessionCount(Collection<String> suids) {
		List<Map<String, Object>> fetchMaps = franchiseCtx
				.select(SSC.SUID, DSL.sum(SSC.TOTAL_OFFICAL_LESSON).as("total"),
						DSL.sum(SSC.CONSUME_OFFICAL_LESSON).as("consume")).from(SSC)
				.where(SSC.SUID.in(suids).and(SSC.STATUS.ne(-1))).fetchMaps();
		if (ArrayMapTools.isEmpty(fetchMaps))
			return Maps.newHashMap();
		Map<String, Pair<Integer, Integer>> result = Maps.newHashMap();
		for (Map<String, Object> has : fetchMaps) {
			if (ArrayMapTools.isEmpty(has) || !ArrayMapTools.containsKeys(has, "suid", "total", "consume"))
				continue;
			result.put(MapUtils.getString(has, "suid"),
					Pair.of(MapUtils.getInteger(has, "total"), MapUtils.getInteger(has, "consume")));
		}
		return result;
	}

	/** 获取当前合同已经请假的天数 */
	public List<StudentSchoolContract> getSimpleStudentSchoolContracts(String suid,
			Map<String, Collection<String>> school2ContractId) {
		Condition condition = getOrWhereCondition(SSC.SCHOOL_ID, SSC.CONTRACT_ID, school2ContractId);
		condition = SSC.SUID.eq(suid).and(condition);
		return franchiseCtx.select(SSC.SCHOOL_ID, SSC.CONTRACT_ID, SSC.LEAVE_NUM, SSC.MAX_LEAVE_NUM).from(SSC)
				.where(condition).fetchInto(StudentSchoolContract.class);
	}

	public StudentSchoolContract getStudentSchoolContract(String suid, String school, String contractId) {
		return franchiseCtx.selectFrom(SSC)
				.where(SSC.SUID.eq(suid).and(SSC.SCHOOL_ID.eq(school)).and(SSC.CONTRACT_ID.eq(contractId)))
				.fetchAnyInto(StudentSchoolContract.class);
	}

	public void addLeaveNum(String suid, String school, String contractId, int addCnt) {
		franchiseCtx.update(SSC).set(SSC.LEAVE_NUM, SSC.LEAVE_NUM.add(addCnt))
				.where(SSC.SUID.eq(suid).and(SSC.SCHOOL_ID.eq(school)).and(SSC.CONTRACT_ID.eq(contractId))).execute();
	}

	public List<StudentSchoolContract> getSSCByContractId(String schoolId, String contractId) {
		return franchiseCtx.selectFrom(SSC).where(SSC.SCHOOL_ID.eq(schoolId).and(SSC.CONTRACT_ID.eq(contractId)))
				.fetchInto(StudentSchoolContract.class);
	}

	public List<Map<String, Object>> mutiCalContractConsumes(List<String> contractIds) {
		return franchiseCtx
				.select(SSC.CONTRACT_ID.as("contractId"),
						DSL.sum(SSC.CONSUME_OFFICAL_LESSON).as("consumeOfficalLesson"),
						DSL.sum(SSC.NO_SCHEDULE_OFFICAL_LESSON).as("noScheduleOfficalLesson")).from(SSC)
				.where(SSC.CONTRACT_ID.in(contractIds)).groupBy(SSC.CONTRACT_ID).fetchMaps();
	}
}
