/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonStudent;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class LessonStudentRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.LessonStudent LS = Tables.LESSON_STUDENT;

    public List<LessonStudent> findSimpleLessonStudentInfo(String suid) {
        return this.franchiseCtx.select((SelectField)LessonStudentRepository.LS.SCHOOL_ID, (SelectField)LessonStudentRepository.LS.LESSON_ID, (SelectField)LessonStudentRepository.LS.CONTRACT_ID, (SelectField)LessonStudentRepository.LS.STATUS).from((TableLike)LS).where(new Condition[]{LessonStudentRepository.LS.SUID.eq((Object)suid)}).fetchInto(LessonStudent.class);
    }

    public LessonStudent getLessonStudent(String schoolId, String lessonId, String suid) {
        List fetchInto = this.franchiseCtx.selectFrom((Table)LS).where(new Condition[]{LessonStudentRepository.LS.SCHOOL_ID.eq((Object)schoolId).and(LessonStudentRepository.LS.LESSON_ID.eq((Object)lessonId)).and(LessonStudentRepository.LS.SUID.eq((Object)suid))}).fetchInto(LessonStudent.class);
        return ArrayMapTools.isNotEmpty((Collection)fetchInto) ? (LessonStudent)fetchInto.get(0) : null;
    }

    public void updateStatus(String schoolId, String lessonId, String suid, int status) {
        this.franchiseCtx.update((Table)LS).set((Field)LessonStudentRepository.LS.STATUS, (Object)status).where(new Condition[]{LessonStudentRepository.LS.SCHOOL_ID.eq((Object)schoolId).and(LessonStudentRepository.LS.LESSON_ID.eq((Object)lessonId)).and(LessonStudentRepository.LS.SUID.eq((Object)suid))}).execute();
    }

    public List<LessonStudent> findFinishedLessonInfo(String suid) {
        return this.franchiseCtx.select((SelectField)LessonStudentRepository.LS.SCHOOL_ID, (SelectField)LessonStudentRepository.LS.LESSON_ID, (SelectField)LessonStudentRepository.LS.STATUS).from((TableLike)LS).where(new Condition[]{LessonStudentRepository.LS.SUID.eq((Object)suid).and(LessonStudentRepository.LS.TYPE.eq((Object)1)).and(LessonStudentRepository.LS.STATUS.in((Object[])new Integer[]{1, 2, 4}))}).fetchInto(LessonStudent.class);
    }
}

