/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.records.ParentInfoRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ParentInfoRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.ParentInfo PI = Tables.PARENT_INFO;

    public void savePatentInfo(String puid, String phone, int appLogin) {
        ParentInfoRecord parent = new ParentInfoRecord();
        parent.setPuid(puid);
        parent.setPhone(phone);
        parent.setAppLogin(Integer.valueOf(appLogin));
        parent.setCreated(Long.valueOf(System.currentTimeMillis()));
        this.franchiseCtx.insertInto((Table)PI).set((Record)parent).onDuplicateKeyIgnore().execute();
    }

    public ParentInfo getParentInfoForPhone(String phone) {
        List parents = this.franchiseCtx.selectFrom((Table)PI).where(new Condition[]{ParentInfoRepository.PI.PHONE.eq((Object)phone)}).fetchInto(ParentInfo.class);
        return ArrayMapTools.isNotEmpty((Collection)parents) ? (ParentInfo)parents.get(0) : null;
    }

    public void updateAppLogin(String phone) {
        this.franchiseCtx.update((Table)PI).set((Field)ParentInfoRepository.PI.APP_LOGIN, (Object)1).where(new Condition[]{ParentInfoRepository.PI.PHONE.eq((Object)phone).and(ParentInfoRepository.PI.APP_LOGIN.eq((Object)0))}).execute();
    }

    public void updateAddressForUid(String puid, String address) {
        this.franchiseCtx.update((Table)PI).set((Field)ParentInfoRepository.PI.ADDRESS, (Object)address).where(new Condition[]{ParentInfoRepository.PI.PUID.eq((Object)puid)}).execute();
    }

    public ParentInfo getParentInfoForId(String uid) {
        List parents = this.franchiseCtx.selectFrom((Table)PI).where(new Condition[]{ParentInfoRepository.PI.PUID.eq((Object)uid)}).fetchInto(ParentInfo.class);
        return ArrayMapTools.isNotEmpty((Collection)parents) ? (ParentInfo)parents.get(0) : null;
    }
}

