package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.other.ConstantsTool;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.Area;

@Lazy
@Repository
public class AreaRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.Area A = Tables.AREA;

	public List<Area> findAllProvinceAndCity() {
		return franchiseCtx.select(A.PROVINCE, A.CITY).from(A).where(A.IS_SHOW.eq(ConstantsTool._1byte))
				.groupBy(A.PROVINCE, A.CITY).fetchInto(Area.class);
	}

}
