package com.jz.jar.franchise.wrapper;

import java.util.List;

import com.google.common.collect.Lists;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;

public class ParentWrapper {

	// 基础信息
	private String puid;
	private String name;
	private String phone;
	private String address;
	private String district;
	private String otherContact;
	private String relation;
	private Long createTime;

	private List<StudentWrapper> childs;

	public static ParentWrapper of(ParentInfo pi) {
		return new ParentWrapper().setPuid(pi.getPuid()).setName(pi.getName()).setPhone(pi.getPhone())
				.setAddress(pi.getAddress()).setDistrict(pi.getDistrict()).setOtherContact(pi.getOtherContact())
				.setRelation(pi.getRelation()).setCreateTime(pi.getCreated());
	}

	public String getPuid() {
		return puid;
	}

	public ParentWrapper setPuid(String puid) {
		this.puid = puid;
		return this;
	}

	public String getName() {
		return name;
	}

	public ParentWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getPhone() {
		return phone;
	}

	public ParentWrapper setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public List<StudentWrapper> getChilds() {
		return childs;
	}

	public ParentWrapper addChild(StudentWrapper child) {
		if (this.childs == null) {
			this.childs = Lists.newArrayList();
		}
		this.childs.add(child);
		return this;
	}

	public ParentWrapper setChilds(List<StudentWrapper> childs) {
		this.childs = childs;
		return this;
	}

	public String getAddress() {
		return address;
	}

	public ParentWrapper setAddress(String address) {
		this.address = address;
		return this;
	}

	public String getRelation() {
		return relation;
	}

	public ParentWrapper setRelation(String relation) {
		this.relation = relation;
		return this;
	}

	public String getDistrict() {
		return district;
	}

	public ParentWrapper setDistrict(String district) {
		this.district = district;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public ParentWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public String getOtherContact() {
		return otherContact;
	}

	public ParentWrapper setOtherContact(String otherContact) {
		this.otherContact = otherContact;
		return this;
	}

}
