package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ClassInfo;
import com.jz.jooq.franchise.tables.records.ClassInfoRecord;

@Lazy
@Repository
public class ClassRepository extends FranchiseBaseRepository implements FranchiseConditionRepository<ClassInfoRecord> {

	private static final com.jz.jooq.franchise.tables.ClassInfo CI = Tables.CLASS_INFO;

	public List<ClassInfo> mutiGetClassInfo(Map<String, Collection<String>> school2Cid) {
		if (ArrayMapTools.isEmpty(school2Cid)) {
			return Lists.newArrayList();
		}
		Condition condition = getOrWhereCondition(CI.SCHOOL_ID, CI.CID, school2Cid);
		return franchiseCtx.selectFrom(CI).where(condition).fetchInto(ClassInfo.class);
	}

	public ClassInfo getClassInfo(String schoolId, String cid) {
		return franchiseCtx.selectFrom(CI).where(CI.SCHOOL_ID.eq(schoolId).and(CI.CID.eq(cid)))
				.fetchAnyInto(ClassInfo.class);
	}
}
