/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.TomatoSchoolCourse;
import com.jz.jooq.franchise.tables.records.TomatoSchoolCourseRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class TomatoSchoolCourseRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.TomatoSchoolCourse T = Tables.TOMATO_SCHOOL_COURSE;

    public void createTomatoSchoolCourse(List<TomatoSchoolCourseRecord> records) {
        this.franchiseCtx.batchInsert(records).execute();
    }

    public void cleanTomatoSchoolCourse(String schoolId) {
        this.franchiseCtx.deleteFrom((Table)T).where(new Condition[]{TomatoSchoolCourseRepository.T.SCHOOL_ID.eq((Object)schoolId)}).execute();
    }

    public List<String> getSchoolCourses(String schoolId) {
        return this.franchiseCtx.select((SelectField)TomatoSchoolCourseRepository.T.LEVEL).from((TableLike)T).where(new Condition[]{TomatoSchoolCourseRepository.T.SCHOOL_ID.eq((Object)schoolId)}).groupBy(new GroupField[]{TomatoSchoolCourseRepository.T.LEVEL}).orderBy(TomatoSchoolCourseRepository.T.LEVEL.asc()).fetchInto(String.class);
    }

    public List<TomatoSchoolCourse> mutiGetSchoolCourses(Collection<String> schoolIds) {
        return this.franchiseCtx.selectFrom((Table)T).where(new Condition[]{TomatoSchoolCourseRepository.T.SCHOOL_ID.in(schoolIds)}).orderBy(TomatoSchoolCourseRepository.T.SCHOOL_ID.asc(), TomatoSchoolCourseRepository.T.LEVEL.asc()).fetchInto(TomatoSchoolCourse.class);
    }
}

