/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.StudentSchool;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class StudentSchoolRepository
extends FranchiseBaseRepository {
    private static final StudentSchool SS = Tables.STUDENT_SCHOOL;

    public boolean isContainsSchool(String suid) {
        return this.franchiseCtx.fetchExists((Table)SS, StudentSchoolRepository.SS.SUID.eq((Object)suid).and(StudentSchoolRepository.SS.HAVE_CONTRACT.eq((Object)1)));
    }

    public List<String> getContainsSchool(Collection<String> suidArray) {
        return this.franchiseCtx.select((SelectField)StudentSchoolRepository.SS.SUID).from((TableLike)SS).where(new Condition[]{StudentSchoolRepository.SS.SUID.in(suidArray).and(StudentSchoolRepository.SS.HAVE_CONTRACT.eq((Object)1))}).fetchInto(String.class);
    }

    public Long getFirstContractTime(String suid, String schoolId) {
        return (Long)this.franchiseCtx.select((SelectField)StudentSchoolRepository.SS.FIRST_CONTRACT_TIME).from((TableLike)SS).where(new Condition[]{StudentSchoolRepository.SS.SUID.eq((Object)suid).and(StudentSchoolRepository.SS.SCHOOL_ID.eq((Object)schoolId))}).fetchAnyInto(Long.class);
    }

    public com.jz.jooq.franchise.tables.pojos.StudentSchool getStopTime(String suid, Collection<String> schoolIds) {
        long timeMillis = System.currentTimeMillis();
        return (com.jz.jooq.franchise.tables.pojos.StudentSchool)this.franchiseCtx.select((SelectField)StudentSchoolRepository.SS.STOP_START_TIME, (SelectField)StudentSchoolRepository.SS.STOP_END_TIME).from((TableLike)SS).where(new Condition[]{StudentSchoolRepository.SS.SUID.eq((Object)suid).and(StudentSchoolRepository.SS.SCHOOL_ID.in(schoolIds)).and(StudentSchoolRepository.SS.HAVE_CONTRACT.eq((Object)1)).and(StudentSchoolRepository.SS.STOP_START_TIME.le((Object)timeMillis)).and(StudentSchoolRepository.SS.STOP_END_TIME.gt((Object)timeMillis))}).orderBy(StudentSchoolRepository.SS.STOP_START_TIME.asc()).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.StudentSchool.class);
    }

    public List<String> getReadingSchoolIds(String suid) {
        return this.franchiseCtx.select((SelectField)StudentSchoolRepository.SS.SCHOOL_ID).from((TableLike)SS).where(new Condition[]{StudentSchoolRepository.SS.SUID.eq((Object)suid).and(StudentSchoolRepository.SS.HAVE_CONTRACT.eq((Object)1)).and(StudentSchoolRepository.SS.STATUS.notEqual((Object)10))}).fetchInto(String.class);
    }

    public List<String> getHaveContractSchoolIds(String suid) {
        return this.franchiseCtx.select((SelectField)StudentSchoolRepository.SS.SCHOOL_ID).from((TableLike)SS).where(new Condition[]{StudentSchoolRepository.SS.SUID.eq((Object)suid).and(StudentSchoolRepository.SS.HAVE_CONTRACT.equal((Object)1))}).orderBy(StudentSchoolRepository.SS.STATUS.asc()).fetchInto(String.class);
    }

    public com.jz.jooq.franchise.tables.pojos.StudentSchool getStudentSchool(String suid, String schoolId) {
        return (com.jz.jooq.franchise.tables.pojos.StudentSchool)this.franchiseCtx.selectFrom((Table)SS).where(new Condition[]{StudentSchoolRepository.SS.SUID.eq((Object)suid).and(StudentSchoolRepository.SS.SCHOOL_ID.eq((Object)schoolId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.StudentSchool.class);
    }

    public Integer getStudentCurrentLevel(String suid, String schoolId) {
        return (Integer)this.franchiseCtx.select((SelectField)StudentSchoolRepository.SS.CURRENT_LEVEL).from((TableLike)SS).where(new Condition[]{StudentSchoolRepository.SS.SUID.eq((Object)suid).and(StudentSchoolRepository.SS.SCHOOL_ID.eq((Object)schoolId))}).fetchAnyInto(Integer.class);
    }

    public int cntStudentsByTeacher(String schoolId, String teacher) {
        return this.franchiseCtx.fetchCount((Table)SS, StudentSchoolRepository.SS.SCHOOL_ID.eq((Object)schoolId).and(StudentSchoolRepository.SS.HAVE_CONTRACT.eq((Object)1)).and(StudentSchoolRepository.SS.TEACHER.eq((Object)teacher).or(StudentSchoolRepository.SS.TEACHER2.eq((Object)teacher))));
    }

    public int cntStudentsByMentor(String schoolId, String mentor) {
        return this.franchiseCtx.fetchCount((Table)SS, StudentSchoolRepository.SS.SCHOOL_ID.eq((Object)schoolId).and(StudentSchoolRepository.SS.HAVE_CONTRACT.eq((Object)1)).and(StudentSchoolRepository.SS.MENTOR.eq((Object)mentor)));
    }

    public int cntStudentsByAdviser(String schoolId, Collection<String> suids) {
        return this.franchiseCtx.fetchCount((Table)SS, StudentSchoolRepository.SS.SCHOOL_ID.eq((Object)schoolId).and(StudentSchoolRepository.SS.HAVE_CONTRACT.eq((Object)1)).and(StudentSchoolRepository.SS.SUID.in(suids)));
    }

    public boolean checkIsReading(Collection<String> schoolIds, Collection<String> suids) {
        return this.franchiseCtx.fetchExists((Table)SS, StudentSchoolRepository.SS.SUID.in(suids).and(StudentSchoolRepository.SS.SCHOOL_ID.in(schoolIds)).and(StudentSchoolRepository.SS.HAVE_CONTRACT.eq((Object)1)).and(StudentSchoolRepository.SS.STATUS.ne((Object)10)));
    }
}

