package com.jz.jar.franchise.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class TravelGiftPackRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.TravelGiftPack TGP = Tables.TRAVEL_GIFT_PACK;

	public boolean existNeedJoinPack(String puid) {
		return franchiseCtx.fetchExists(TGP,
				TGP.PUID.eq(puid).and(TGP.STATUS.eq(0).and(TGP.END_TIME.gt(System.currentTimeMillis()))));
	}
}
