package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.StudentCert;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class StudentCertRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentCert SC = Tables.STUDENT_CERT;

	public List<StudentCert> getStudentAllCerts(String suid) {
		return franchiseCtx.selectFrom(SC).where(SC.SUID.eq(suid)).and(SC.STATUS.eq(1)).orderBy(SC.CREATE_TIME.desc())
				.fetchInto(StudentCert.class);
	}

}
