package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.TomatoCourseLevelReportRepository;
import com.jz.jooq.franchise.tables.pojos.TomatoCourseLevelReport;

@Lazy
@Service
public class TomatoCourseLevelReportService {

	@Autowired
	private TomatoCourseLevelReportRepository tomatoCourseLevelReportRepository;

	public TomatoCourseLevelReport getLevelReport(String id) {
		return tomatoCourseLevelReportRepository.getLevelReport(id);
	}

	public List<TomatoCourseLevelReport> getSimplePublishReportBySuid(String suid) {
		return tomatoCourseLevelReportRepository.getSimplePublishReportBySuid(suid);
	}

	public List<TomatoCourseLevelReport> getSimplePublishReportBySuids(Collection<String> suids) {
		return tomatoCourseLevelReportRepository.getSimplePublishReportBySuids(suids);
	}

}
