package com.jz.jar.franchise.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ActivityRedpackRepository;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackDetail;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackRank;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateRedpack;

@Lazy
@Service
public class ActivityRedpackService {

	private static final Logger logger = LoggerFactory.getLogger(ActivityRedpackService.class);

	@Autowired
	private ActivityRedpackRepository activityRedpackRepository;
	@Autowired
	private ActivityCompnayPayService activityCompnayPayService;

	public void recordRecom(String jzUrl, String paySignKey, String activityId, String downOpenId, String upOpenId) {
		if (upOpenId == null) {
			upOpenId = "";
		}
		if (StringUtils.equals(downOpenId, upOpenId)) {
			logger.warn("downOpenId upOpenId eq:" + downOpenId);
			upOpenId = "";
		}
		if (activityRedpackRepository.isRegDownId(activityId, downOpenId)) {
			// 只注册推荐关系一次
			return;
		}
		activityRedpackRepository.createRecom(activityId, downOpenId, upOpenId);
		activityRedpackRepository.increTotalSignNum(activityId, 1);
		if (StringUtils.isEmpty(upOpenId)) {
			// 如果上游为空，那么啥都不干
			return;
		}
		ActivityTemplateRedpack setting = activityRedpackRepository.getRedpackSetting(activityId);
		if (setting == null) {
			logger.warn("setting null");
			return;
		}
		String type = "down_view";
		double money = 0;
		int payRs = 0;
		if (setting.getViewPerNum() > 0 && setting.getViewMoney().doubleValue() > 0) {
			// 尝试给浏览红包
			int downCnts = activityRedpackRepository.cntDowns(activityId, upOpenId);
			if (downCnts <= setting.getViewPerNum() * setting.getViewMaxTime()) { // 如果没有到最大个数
				if (downCnts % setting.getViewPerNum() == 0) { // 如果正好整除
					money = setting.getViewMoney().doubleValue();
				}
			}
		}
		if (money > 0) {
			if (setting.getViewTotalMax() > 0
					&& activityCompnayPayService.cntSucTotalNum(activityId, type) >= setting.getViewTotalMax()) {
				payRs = 3;
			} else {
				// 自动给用户下发红包
				boolean rs = activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId, type, money,
						"", "参与活动获得好友浏览红包");
				payRs = rs ? 1 : 2;
			}
		}
		activityRedpackRepository.createDetail(activityId, upOpenId, type, downOpenId,
				money > 0 ? new BigDecimal(money) : null, payRs, "");
		activityRedpackRepository.increRank(activityId, type, upOpenId, 1);

	}

	public void recordBuy(String jzUrl, String paySignKey, String activityId, String openId, String orderNo,
			String productName) {
		ActivityTemplateRedpack setting = activityRedpackRepository.getRedpackSetting(activityId);
		if (setting == null) {
			logger.warn("setting null");
			return;
		}
		{
			String type = "self_buy";
			double money = setting.getBuySelfMoney().doubleValue();
			if (activityRedpackRepository.cntDetailPage(activityId, openId, type) <= 0) {
				String remark = "购买" + productName + (money > 0 ? "获得红包" : "");
				int payRs = 0;
				if (money > 0) {
					if (setting.getBuySelfTotalMax() > 0
							&& activityCompnayPayService.cntSucTotalNum(activityId, type) >= setting
									.getBuySelfTotalMax()) {
						payRs = 3;
					} else {
						boolean rs = activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, openId, type,
								money, orderNo, remark);
						payRs = rs ? 1 : 2;
					}
				}
				activityRedpackRepository.createDetail(activityId, openId, type, openId, money > 0 ? new BigDecimal(
						money) : null, payRs, remark);
			}
		}
		{
			String upOpenId = activityRedpackRepository.getUpOpenId(activityId, openId);
			if (StringUtils.isNotEmpty(upOpenId)) {
				String type = "down_buy";
				double money = 0;
				int payRs = 0;
				if (setting.getBuyRecomMoney().doubleValue() > 0
						&& activityCompnayPayService.cntByActOpenType(activityId, upOpenId, type) <= setting
								.getBuyMaxTime()) {
					money = setting.getBuyRecomMoney().doubleValue();
				}
				if (money > 0) {
					if (setting.getBuyRecomTotalMax() > 0
							&& activityCompnayPayService.cntSucTotalNum(activityId, type) >= setting
									.getBuyRecomTotalMax()) {
						payRs = 3;
					} else {
						// 自动给用户下发红包
						boolean rs = activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId,
								type, money, "", "参与活动获得好友购买红包");
						payRs = rs ? 1 : 2;
					}
				}
				activityRedpackRepository.createDetail(activityId, upOpenId, type, openId, money > 0 ? new BigDecimal(
						money) : null, payRs, "");
				activityRedpackRepository.increRank(activityId, type, upOpenId, 1);
			}
		}
	}

	/**
	 * 这里返回填表需要自动赠送的课包
	 * */
	public String recordForm(String jzUrl, String paySignKey, String activityId, String openId) {
		ActivityTemplateRedpack setting = activityRedpackRepository.getRedpackSetting(activityId);
		if (setting == null) {
			logger.warn("setting null");
			return null;
		}
		{
			String type = "self_form";
			double money = setting.getFormSelfMoney().doubleValue();
			if (activityRedpackRepository.cntDetailPage(activityId, openId, type) <= 0) {
				String remark = "参与活动" + (money > 0 ? "获得红包" : "");
				int payRs = 0;
				if (money > 0) {
					if (setting.getFormSelfTotalMax() > 0
							&& activityCompnayPayService.cntSucTotalNum(activityId, type) >= setting
									.getFormSelfTotalMax()) {
						payRs = 3;
					} else {
						boolean rs = activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, openId, type,
								setting.getFormSelfMoney().doubleValue(), "", remark);
						payRs = rs ? 1 : 2;
					}
				}
				activityRedpackRepository.createDetail(activityId, openId, type, openId, money > 0 ? new BigDecimal(
						money) : null, payRs, remark);
			}
		}
		{
			String upOpenId = activityRedpackRepository.getUpOpenId(activityId, openId);
			if (StringUtils.isNotEmpty(upOpenId)) {
				String type = "down_form";
				double money = 0;
				int payRs = 0;
				if (setting.getFormRecomMoney().doubleValue() > 0
						&& activityCompnayPayService.cntByActOpenType(activityId, upOpenId, type) <= setting
								.getFormMaxTime()) {
					money = setting.getFormRecomMoney().doubleValue();
				}
				if (money > 0) {
					if (setting.getFormRecomTotalMax() > 0
							&& activityCompnayPayService.cntSucTotalNum(activityId, type) >= setting
									.getFormRecomTotalMax()) {
						payRs = 3;
					} else {
						// 自动给用户下发红包
						boolean rs = activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId,
								type, money, "", "参与活动获得好友报名红包");
						payRs = rs ? 1 : 2;
					}
				}
				activityRedpackRepository.createDetail(activityId, upOpenId, type, openId, money > 0 ? new BigDecimal(
						money) : null, payRs, "");
				activityRedpackRepository.increRank(activityId, type, upOpenId, 1);
			}
		}
		return setting.getFormAutoGiftPid();
	}

	public int cntDetailPage(String activityId, String upOpenId, String type) {
		return activityRedpackRepository.cntDetailPage(activityId, upOpenId, type);
	}

	public List<ActivityRedpackDetail> getDetailPage(String activityId, String upOpenId, String type, int start,
			int size) {
		List<ActivityRedpackDetail> details = activityRedpackRepository.getDetailPage(activityId, upOpenId, type,
				start, size);
		// 这里如果下发红包失败，则不显示红包金额
		for (ActivityRedpackDetail d : details) {
			if (d.getMoney() != null && (d.getPayRs() == null || d.getPayRs() != 1)) {
				d.setMoney(null);
			}
		}
		return details;
	}

	public List<ActivityRedpackDetail> getDetailByTypes(String activityId, String upOpenId, Collection<String> types) {
		List<ActivityRedpackDetail> details = activityRedpackRepository.getDetailByTypes(activityId, upOpenId, types);
		// 这里如果下发红包失败，则不显示红包金额
		for (ActivityRedpackDetail d : details) {
			if (d.getMoney() != null && (d.getPayRs() == null || d.getPayRs() != 1)) {
				d.setMoney(null);
			}
		}
		return details;
	}

	public List<ActivityRedpackRank> getRank(String activityId, String type, int size) {
		return activityRedpackRepository.getRank(activityId, type, size);
	}

	public String getUpOpenId(String activityId, String downOpenId) {
		return activityRedpackRepository.getUpOpenId(activityId, downOpenId);
	}
}
