package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.TomatoCourseLevelReport;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class TomatoCourseLevelReportRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.TomatoCourseLevelReport TCLR = Tables.TOMATO_COURSE_LEVEL_REPORT;

	public TomatoCourseLevelReport getLevelReport(String id) {
		return franchiseCtx.selectFrom(TCLR).where(TCLR.ID.eq(id)).fetchAnyInto(TomatoCourseLevelReport.class);
	}

	public List<TomatoCourseLevelReport> getSimplePublishReportBySuid(String suid) {
		return franchiseCtx
				.select(TCLR.ID, TCLR.SUID, TCLR.SCHOOL_ID, TCLR.LEVEL, TCLR.YEAR, TCLR.REPORT_NAME, TCLR.CHILD_NAME,
						TCLR.STATUS, TCLR.CREATE_TIME, TCLR.LAST_EDIT_TIME, TCLR.LAST_EDIT_USER, TCLR.PUBLISH_TIME)
				.from(TCLR).where(TCLR.SUID.eq(suid).and(TCLR.STATUS.eq(20))).orderBy(TCLR.PUBLISH_TIME.desc())
				.fetchInto(TomatoCourseLevelReport.class);
	}

	public List<TomatoCourseLevelReport> getSimplePublishReportBySuids(Collection<String> suids) {
		return franchiseCtx
				.select(TCLR.ID, TCLR.SUID, TCLR.SCHOOL_ID, TCLR.LEVEL, TCLR.YEAR, TCLR.REPORT_NAME, TCLR.CHILD_NAME,
						TCLR.STATUS, TCLR.CREATE_TIME, TCLR.LAST_EDIT_TIME, TCLR.LAST_EDIT_USER, TCLR.PUBLISH_TIME)
				.from(TCLR).where(TCLR.SUID.in(suids).and(TCLR.STATUS.eq(20))).orderBy(TCLR.PUBLISH_TIME.desc())
				.fetchInto(TomatoCourseLevelReport.class);
	}
}
