package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.TomatoAreaReport;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class TomatoAreaReportRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.TomatoAreaReport TAR = Tables.TOMATO_AREA_REPORT;

	public List<TomatoAreaReport> getSimplePublishReportBySuids(Collection<String> suids) {
		return franchiseCtx
				.select(TAR.ID, TAR.SUID, TAR.SCHOOL_ID, TAR.SETTING_ID, TAR.REPORT_NAME, TAR.LEVEL, TAR.TOPIC_AREA,
						TAR.PLAN_NAME, TAR.CHILD_NAME, TAR.STATUS, TAR.CREATE_TIME, TAR.LAST_EDIT_TIME,
						TAR.LAST_EDIT_USER, TAR.PUBLISH_TIME)
				.from(TAR).where(TAR.SUID.in(suids).and(TAR.STATUS.eq(20))).orderBy(TAR.PUBLISH_TIME.desc())
				.fetchInto(TomatoAreaReport.class);
	}

}
