package com.jz.jar.franchise.repository;

import java.math.BigDecimal;
import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.PaperCertOrder;
import com.jz.jooq.franchise.tables.records.PaperCertOrderRecord;

/**
 * 纸质证书订单相关
 */
@Lazy
@Repository
public class PaperCertRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.PaperCertOrder PCO = Tables.PAPER_CERT_ORDER;

	public void createOrder(PaperCertOrderRecord record) {
		franchiseCtx.batchInsert(record).execute();
	}

	public void finishPay(String orderId, BigDecimal payMoney, String paymentMode, String onlineTradeId) {
		franchiseCtx.update(PCO).set(PCO.PAY_MONEY, payMoney).set(PCO.PAYMENT_MODE, paymentMode)
				.set(PCO.ONLINE_PAY_TRADE_ID, onlineTradeId).set(PCO.STATUS, 1)
				.set(PCO.PAY_TIME, System.currentTimeMillis()).where(PCO.ID.eq(orderId)).execute();
	}

	public PaperCertOrder getOrder(String orderId) {
		return franchiseCtx.selectFrom(PCO).where(PCO.ID.eq(orderId)).fetchAnyInto(PaperCertOrder.class);
	}

	public int cntUserOrderPage(String puid, boolean needAll) {
		return franchiseCtx.fetchCount(PCO, this.genUserOrderPageWhere(puid, needAll));
	}

	public List<PaperCertOrder> getOrderPage(String puid, boolean needAll, int start, int size) {
		return franchiseCtx.selectFrom(PCO).where(this.genUserOrderPageWhere(puid, needAll))
				.orderBy(PCO.CREATE_TIME.desc(), PCO.ID.asc()).limit(start, size).fetchInto(PaperCertOrder.class);
	}

	private Condition genUserOrderPageWhere(String puid, boolean needAll) {
		Condition c = PCO.PUID.eq(puid);
		if (needAll) {
			c = c.and(PCO.STATUS.ge(1));
		} else {
			c = c.and(PCO.STATUS.eq(1));
		}
		return c;
	}

	public void applyRefund(String id, int status, String refundReason, String refundOperator) {
		franchiseCtx.update(PCO).set(PCO.STATUS, status).set(PCO.REFUND_REASON, refundReason)
				.set(PCO.REFUND_APPLY_TIME, System.currentTimeMillis()).set(PCO.REFUND_OPERATOR, refundOperator)
				.where(PCO.ID.eq(id)).execute();
	}
}
