package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonStudentDaka;
import com.jz.jooq.franchise.tables.records.LessonStudentDakaRecord;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class LessonStudentDakaRepository extends FranchiseBaseRepository
		implements FranchiseConditionRepository<LessonStudentDakaRecord> {

	private static final com.jz.jooq.franchise.tables.LessonStudentDaka LSD = Tables.LESSON_STUDENT_DAKA;

	public void createStudentDaka(LessonStudentDakaRecord record) {
		franchiseCtx.batchInsert(record).execute();
	}

	public void updateStudentDaka(LessonStudentDakaRecord record) {
		franchiseCtx.batchUpdate(record).execute();
	}

	public LessonStudentDaka getStudentDaka(String schoolId, String lessonId, String suid) {
		return franchiseCtx.selectFrom(LSD)
				.where(LSD.SCHOOL_ID.eq(schoolId).and(LSD.LESSON_ID.eq(lessonId)).and(LSD.SUID.eq(suid)))
				.orderBy(LSD.CREATE_TIME.desc()).fetchAnyInto(LessonStudentDaka.class);
	}

	public List<LessonStudentDaka> getStudentDakaListByLessonId(String schoolId, String lessonId) {
		return franchiseCtx.selectFrom(LSD).where(LSD.SCHOOL_ID.eq(schoolId).and(LSD.LESSON_ID.eq(lessonId)))
				.orderBy(LSD.CREATE_TIME.desc()).fetchInto(LessonStudentDaka.class);
	}

	public List<LessonStudentDaka> mutiGetStudentDakaBySchoolIdsLessonIds(String suid,
			Map<String, Collection<String>> schoolId2LessonIds) {
		return franchiseCtx.selectFrom(LSD)
				.where(LSD.SUID.eq(suid).and(getOrWhereCondition(LSD.SCHOOL_ID, LSD.LESSON_ID, schoolId2LessonIds)))
				.fetchInto(LessonStudentDaka.class);
	}

}
