package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoTopic;

@Lazy
@Repository
public class CourseTomatoTopicRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CourseTomatoTopic CT = Tables.COURSE_TOMATO_TOPIC;

	public int countTopics(String branchId) {
		return franchiseCtx.fetchCount(CT, CT.BRAND_ID.eq(branchId));
	}

	public List<CourseTomatoTopic> findTopics(String branchId, int start, int size) {
		return franchiseCtx.selectFrom(CT).where(CT.BRAND_ID.eq(branchId).and(CT.SEQ.gt(0L))).orderBy(CT.SEQ.desc())
				.limit(start, size).fetchInto(CourseTomatoTopic.class);
	}

	public CourseTomatoTopic getTopic(String branchId, String tid) {
		return franchiseCtx.selectFrom(CT).where(CT.BRAND_ID.eq(branchId).and(CT.TID.eq(tid)))
				.fetchAnyInto(CourseTomatoTopic.class);
	}
}
