package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.StudentStudyOnlineRepository;
import com.jz.jooq.franchise.tables.pojos.StudentStudyOnline;

@Lazy
@Service
public class StudentStudyOnlineService {

	@Autowired
	private StudentStudyOnlineRepository studentStudyOnlineRepository;

	public int getPlayLength(String suid, String wid) {
		return studentStudyOnlineRepository.getPlayLength(suid, wid);
	}
	
	public StudentStudyOnline getStudentOnline(String suid, String wid) {
		return studentStudyOnlineRepository.getStudentOnline(suid, wid);
	}

	public List<StudentStudyOnline> mutiGetPlayLength(String suid, Collection<String> wids) {
		return studentStudyOnlineRepository.mutiGetPlayLength(suid, wids);
	}

	public void insUpdatePlayLength(String suid, String wid, int playLength, int maxPlayLength) {
		studentStudyOnlineRepository.insUpdatePlayLength(suid, wid, playLength, maxPlayLength);
	}

}
