package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ClassDetail;
import com.jz.jooq.franchise.tables.records.ClassDetailRecord;

@Lazy
@Repository
public class ClassDetailRepository extends FranchiseBaseRepository
		implements FranchiseConditionRepository<ClassDetailRecord> {

	private static final com.jz.jooq.franchise.tables.ClassDetail CD = Tables.CLASS_DETAIL;

	public List<ClassDetail> mutiGetClassDetails(Map<String, Collection<String>> school2Cid) {
		if (ArrayMapTools.isEmpty(school2Cid)) {
			return Lists.newArrayList();
		}
		Condition condition = getOrWhereCondition(CD.SCHOOL_ID, CD.CID, school2Cid);
		return franchiseCtx.selectFrom(CD).where(condition).fetchInto(ClassDetail.class);
	}

	public List<ClassDetail> getClassDetail(String schoolId, String cid) {
		return franchiseCtx.selectFrom(CD).where(CD.SCHOOL_ID.eq(schoolId).and(CD.CID.eq(cid)))
				.fetchInto(ClassDetail.class);
	}
}
