package com.jz.jar.franchise.service;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.MarketCasePoolRepository;
import com.jz.jar.franchise.wrapper.CaseChildWrapper;
import com.jz.jooq.franchise.tables.pojos.MarketCasePool;

@Lazy
@Service
public class MarketCasePoolService {

	@Autowired
	private MarketCasePoolRepository marketCasePoolRepository;

	public MarketCasePool getMarketCaseById(String caseId, String schoolId) {
		return marketCasePoolRepository.getMarketCaseById(caseId, schoolId);
	}

	public MarketCasePool getMarketCaseByPhone(String schoolId, String phone) {
		return marketCasePoolRepository.getMarketCaseByPhone(schoolId, phone);
	}

	public MarketCasePool getMarketCaseByPuid(String schoolId, String puid) {
		return marketCasePoolRepository.getMarketCaseByPuid(schoolId, puid);
	}

	public void createCase(String caseId, String uid, String schoolId, String channelId, String phone, String wechat,
			String qq, List<CaseChildWrapper> childs, String childPy, String parentName, String relation,
			String address, String district, String level, long nextCommunicateTime) {
		marketCasePoolRepository.createCase(caseId, uid, schoolId, channelId, phone, wechat, qq, childs, childPy,
				parentName, relation, address, district, level, nextCommunicateTime);
	}

	public void joinAuditionForOldCase(MarketCasePool mcp, String channelId) {
		String schoolId = mcp.getSchoolId();
		marketCasePoolRepository.updateLastCreatedAndCreateNumForCurrent(mcp.getId());
		if (!StringUtils.equals(mcp.getChannelId(), channelId)) {
			marketCasePoolRepository.createCommunicateRecord(schoolId, mcp.getId(), "", "该潜客预约了试听，请尽快沟通", "", "", 0);
		}
		if (StringUtils.equals(mcp.getLevel(), "D")) { // 已经废弃的用户，自动修改评级为待分配
			marketCasePoolRepository.updateCaseLevel(schoolId, mcp.getId(), "Z");
		}
	}
}
