package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class FestivalAvoidRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.FestivalAvoid FA = Tables.FESTIVAL_AVOID;

	public List<String> getHoliday(Collection<String> schools, String start, String end) {
		return franchiseCtx.select(FA.NAME).from(FA)
				.where(FA.SCHOOL_ID.in(schools).and(FA.START_DATE.le(end)).and(FA.END_DATE.ge(start)))
				.orderBy(FA.START_DATE.asc()).fetchInto(String.class);
	}
}
