package com.jz.jar.franchise.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ActivityShareQr;
import com.jz.jooq.franchise.tables.records.ActivityShareQrRecord;

@Lazy
@Repository
public class ActivityShareQrRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ActivityShareQr ASQ = Tables.ACTIVITY_SHARE_QR;

	public ActivityShareQr getShareQrById(String id) {
		return franchiseCtx.selectFrom(ASQ).where(ASQ.ID.eq(id)).fetchAnyInto(ActivityShareQr.class);
	}

	public ActivityShareQr getShareQrByActId(String activityId, String puid) {
		return franchiseCtx.selectFrom(ASQ).where(ASQ.ACTIVITY_ID.eq(activityId).and(ASQ.PUID.eq(puid)))
				.fetchAnyInto(ActivityShareQr.class);
	}

	public void insUpdShareQr(ActivityShareQrRecord record) {
		franchiseCtx.insertInto(ASQ).set(record).onDuplicateKeyUpdate().set(record).execute();
	}
}
