package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.TomatoSchoolCourse;
import com.jz.jooq.franchise.tables.records.TomatoSchoolCourseRecord;

@Lazy
@Repository
public class TomatoSchoolCourseRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.TomatoSchoolCourse T = Tables.TOMATO_SCHOOL_COURSE;

	public void createTomatoSchoolCourse(List<TomatoSchoolCourseRecord> records) {
		franchiseCtx.batchInsert(records).execute();
	}

	public void cleanTomatoSchoolCourse(String schoolId) {
		franchiseCtx.deleteFrom(T).where(T.SCHOOL_ID.eq(schoolId)).execute();
	}

	public List<String> getSchoolCourses(String schoolId) {
		return franchiseCtx.select(T.LEVEL).from(T).where(T.SCHOOL_ID.eq(schoolId)).groupBy(T.LEVEL)
				.orderBy(T.LEVEL.asc()).fetchInto(String.class);
	}

	public List<TomatoSchoolCourse> mutiGetSchoolCourses(Collection<String> schoolIds) {
		return franchiseCtx.selectFrom(T).where(T.SCHOOL_ID.in(schoolIds)).orderBy(T.SCHOOL_ID.asc(), T.LEVEL.asc())
				.fetchInto(TomatoSchoolCourse.class);
	}

}
