package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ContractCompany;
import com.jz.jooq.franchise.tables.records.ContractCompanyRecord;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class ContractCompanyRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ContractCompany CC = Tables.CONTRACT_COMPANY;

	public ContractCompany getContractCompany(String schoolId, Integer id) {
		return franchiseCtx.selectFrom(CC).where(CC.SCHOOL_ID.eq(schoolId).and(CC.ID.eq(id)))
				.fetchAnyInto(ContractCompany.class);
	}

	public List<ContractCompany> mutiGetContractCompany(Collection<String> schoolIds) {
		return franchiseCtx.selectFrom(CC).where(CC.SCHOOL_ID.in(schoolIds)).fetchInto(ContractCompany.class);
	}

	public int getMaxCompanyId(String schoolId) {
		Integer rs = franchiseCtx.select(DSL.max(CC.ID)).from(CC).where(CC.SCHOOL_ID.eq(schoolId))
				.fetchAnyInto(Integer.class);
		return rs != null ? rs : 0;
	}

	public void createContractCompany(ContractCompanyRecord record) {
		franchiseCtx.batchInsert(record).execute();
	}
}
