package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class StudentRelParentRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentRelParent SRP = Tables.STUDENT_REL_PARENT;

	public List<String> getSuidsByRelPuid(String relPuid) {
		return franchiseCtx.select(SRP.SUID).from(SRP).where(SRP.REL_PUID.eq(relPuid)).fetchInto(String.class);
	}

	public boolean checkSuidRelPuid(String suid, String relPuid) {
		return franchiseCtx.fetchExists(SRP, SRP.SUID.eq(suid).and(SRP.REL_PUID.eq(relPuid)));
	}

}
