/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.jz.jar.franchise.repository.ActivityRedpackRepository;
import com.jz.jar.franchise.service.ActivityCompnayPayService;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackDetail;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackRank;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateRedpack;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ActivityRedpackService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRedpackService.class);
    @Autowired
    private ActivityRedpackRepository activityRedpackRepository;
    @Autowired
    private ActivityCompnayPayService activityCompnayPayService;

    public void recordRecom(String jzUrl, String paySignKey, String activityId, String downOpenId, String upOpenId) {
        int downCnts;
        if (upOpenId == null) {
            upOpenId = "";
        }
        if (StringUtils.equals((CharSequence)downOpenId, (CharSequence)upOpenId)) {
            logger.warn("downOpenId upOpenId eq:" + downOpenId);
            upOpenId = "";
        }
        if (this.activityRedpackRepository.isRegDownId(activityId, downOpenId)) {
            return;
        }
        this.activityRedpackRepository.createRecom(activityId, downOpenId, upOpenId);
        this.activityRedpackRepository.increTotalSignNum(activityId, 1);
        if (StringUtils.isEmpty((CharSequence)upOpenId)) {
            return;
        }
        ActivityTemplateRedpack setting = this.activityRedpackRepository.getRedpackSetting(activityId);
        if (setting == null) {
            logger.warn("setting null");
            return;
        }
        String type = "down_view";
        double money = 0.0;
        int payRs = 0;
        if (setting.getViewPerNum() > 0 && setting.getViewMoney().doubleValue() > 0.0 && (downCnts = this.activityRedpackRepository.cntDowns(activityId, upOpenId)) <= setting.getViewPerNum() * setting.getViewMaxTime() && downCnts % setting.getViewPerNum() == 0) {
            money = setting.getViewMoney().doubleValue();
        }
        if (money > 0.0) {
            boolean rs;
            payRs = setting.getViewTotalMax() > 0 && this.activityCompnayPayService.cntSucTotalNum(activityId, type) >= setting.getViewTotalMax() ? 3 : ((rs = this.activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId, type, money, "", "\u53c2\u4e0e\u6d3b\u52a8\u83b7\u5f97\u597d\u53cb\u6d4f\u89c8\u7ea2\u5305")) ? 1 : 2);
        }
        this.activityRedpackRepository.createDetail(activityId, upOpenId, type, downOpenId, money > 0.0 ? new BigDecimal(money) : null, payRs, "");
        this.activityRedpackRepository.increRank(activityId, type, upOpenId, 1);
    }

    public void recordBuy(String jzUrl, String paySignKey, String activityId, String openId, String orderNo, String productName) {
        String upOpenId;
        boolean rs;
        int payRs;
        ActivityTemplateRedpack setting = this.activityRedpackRepository.getRedpackSetting(activityId);
        if (setting == null) {
            logger.warn("setting null");
            return;
        }
        String type = "self_buy";
        double money = setting.getBuySelfMoney().doubleValue();
        if (this.activityRedpackRepository.cntDetailPage(activityId, openId, type) <= 0) {
            String remark = "\u8d2d\u4e70" + productName + (money > 0.0 ? "\u83b7\u5f97\u7ea2\u5305" : "");
            payRs = 0;
            if (money > 0.0) {
                payRs = setting.getBuySelfTotalMax() > 0 && this.activityCompnayPayService.cntSucTotalNum(activityId, type) >= setting.getBuySelfTotalMax() ? 3 : ((rs = this.activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, openId, type, money, orderNo, remark)) ? 1 : 2);
            }
            this.activityRedpackRepository.createDetail(activityId, openId, type, openId, money > 0.0 ? new BigDecimal(money) : null, payRs, remark);
        }
        if (StringUtils.isNotEmpty((CharSequence)(upOpenId = this.activityRedpackRepository.getUpOpenId(activityId, openId)))) {
            String type2 = "down_buy";
            double money2 = 0.0;
            payRs = 0;
            if (setting.getBuyRecomMoney().doubleValue() > 0.0 && this.activityCompnayPayService.cntByActOpenType(activityId, upOpenId, type2) <= setting.getBuyMaxTime()) {
                money2 = setting.getBuyRecomMoney().doubleValue();
            }
            if (money2 > 0.0) {
                payRs = setting.getBuyRecomTotalMax() > 0 && this.activityCompnayPayService.cntSucTotalNum(activityId, type2) >= setting.getBuyRecomTotalMax() ? 3 : ((rs = this.activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId, type2, money2, "", "\u53c2\u4e0e\u6d3b\u52a8\u83b7\u5f97\u597d\u53cb\u8d2d\u4e70\u7ea2\u5305")) ? 1 : 2);
            }
            this.activityRedpackRepository.createDetail(activityId, upOpenId, type2, openId, money2 > 0.0 ? new BigDecimal(money2) : null, payRs, "");
            this.activityRedpackRepository.increRank(activityId, type2, upOpenId, 1);
        }
    }

    public String recordForm(String jzUrl, String paySignKey, String activityId, String openId) {
        String upOpenId;
        boolean rs;
        int payRs;
        ActivityTemplateRedpack setting = this.activityRedpackRepository.getRedpackSetting(activityId);
        if (setting == null) {
            logger.warn("setting null");
            return null;
        }
        String type = "self_form";
        double money = setting.getFormSelfMoney().doubleValue();
        if (this.activityRedpackRepository.cntDetailPage(activityId, openId, type) <= 0) {
            String remark = "\u53c2\u4e0e\u6d3b\u52a8" + (money > 0.0 ? "\u83b7\u5f97\u7ea2\u5305" : "");
            payRs = 0;
            if (money > 0.0) {
                payRs = setting.getFormSelfTotalMax() > 0 && this.activityCompnayPayService.cntSucTotalNum(activityId, type) >= setting.getFormSelfTotalMax() ? 3 : ((rs = this.activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, openId, type, setting.getFormSelfMoney().doubleValue(), "", remark)) ? 1 : 2);
            }
            this.activityRedpackRepository.createDetail(activityId, openId, type, openId, money > 0.0 ? new BigDecimal(money) : null, payRs, remark);
        }
        if (StringUtils.isNotEmpty((CharSequence)(upOpenId = this.activityRedpackRepository.getUpOpenId(activityId, openId)))) {
            String type2 = "down_form";
            double money2 = 0.0;
            payRs = 0;
            if (setting.getFormRecomMoney().doubleValue() > 0.0 && this.activityCompnayPayService.cntByActOpenType(activityId, upOpenId, type2) <= setting.getFormMaxTime()) {
                money2 = setting.getFormRecomMoney().doubleValue();
            }
            if (money2 > 0.0) {
                payRs = setting.getFormRecomTotalMax() > 0 && this.activityCompnayPayService.cntSucTotalNum(activityId, type2) >= setting.getFormRecomTotalMax() ? 3 : ((rs = this.activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId, type2, money2, "", "\u53c2\u4e0e\u6d3b\u52a8\u83b7\u5f97\u597d\u53cb\u62a5\u540d\u7ea2\u5305")) ? 1 : 2);
            }
            this.activityRedpackRepository.createDetail(activityId, upOpenId, type2, openId, money2 > 0.0 ? new BigDecimal(money2) : null, payRs, "");
            this.activityRedpackRepository.increRank(activityId, type2, upOpenId, 1);
        }
        return setting.getFormAutoGiftPid();
    }

    public int cntDetailPage(String activityId, String upOpenId, String type) {
        return this.activityRedpackRepository.cntDetailPage(activityId, upOpenId, type);
    }

    public List<ActivityRedpackDetail> getDetailPage(String activityId, String upOpenId, String type, int start, int size) {
        List<ActivityRedpackDetail> details = this.activityRedpackRepository.getDetailPage(activityId, upOpenId, type, start, size);
        for (ActivityRedpackDetail d : details) {
            if (d.getMoney() == null || d.getPayRs() != null && d.getPayRs() == 1) continue;
            d.setMoney(null);
        }
        return details;
    }

    public List<ActivityRedpackDetail> getDetailByTypes(String activityId, String upOpenId, Collection<String> types) {
        List<ActivityRedpackDetail> details = this.activityRedpackRepository.getDetailByTypes(activityId, upOpenId, types);
        for (ActivityRedpackDetail d : details) {
            if (d.getMoney() == null || d.getPayRs() != null && d.getPayRs() == 1) continue;
            d.setMoney(null);
        }
        return details;
    }

    public List<ActivityRedpackRank> getRank(String activityId, String type, int size) {
        return this.activityRedpackRepository.getRank(activityId, type, size);
    }

    public String getUpOpenId(String activityId, String downOpenId) {
        return this.activityRedpackRepository.getUpOpenId(activityId, downOpenId);
    }
}

