package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.TomatoCourseLevelCert;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class TomatoCourseLevelCertRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.TomatoCourseLevelCert TCLC = Tables.TOMATO_COURSE_LEVEL_CERT;

	public List<TomatoCourseLevelCert> getCertsBySuid(String suid) {
		return franchiseCtx.selectFrom(TCLC).where(TCLC.SUID.eq(suid)).orderBy(TCLC.CREATE_TIME.desc())
				.fetchInto(TomatoCourseLevelCert.class);
	}

	public List<TomatoCourseLevelCert> getCertsBySuids(List<String> suids) {
		return franchiseCtx.selectFrom(TCLC).where(TCLC.SUID.in(suids)).orderBy(TCLC.CREATE_TIME.desc())
				.fetchInto(TomatoCourseLevelCert.class);
	}

	public TomatoCourseLevelCert getCertById(String id) {
		return franchiseCtx.selectFrom(TCLC).where(TCLC.ID.eq(id)).fetchAnyInto(TomatoCourseLevelCert.class);
	}

}
