package com.jz.jar.franchise.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class CourseHoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CourseHo CH = Tables.COURSE_HO;

	public String getCourseName(String brand, Integer courseId) {
		return franchiseCtx.select(CH.COURSE_NAME).from(CH).where(CH.BRAND_ID.eq(brand).and(CH.COURSE_ID.eq(courseId)))
				.fetchAnyInto(String.class);
	}
}
