package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ArtAlbumRepository;
import com.jz.jooq.franchise.tables.pojos.ArtAlbumInfo;
import com.jz.jooq.franchise.tables.pojos.ArtAlbumOrder;

@Lazy
@Service
public class ArtAlbumService {

	@Autowired
	private ArtAlbumRepository artAlbumRepository;

	public ArtAlbumInfo getInfo(String albumId) {
		return artAlbumRepository.getInfo(albumId);
	}

	public List<ArtAlbumInfo> mutiGetInfos(Collection<String> albumIds) {
		return artAlbumRepository.mutiGetInfos(albumIds);
	}

	public List<ArtAlbumOrder> mutiGetOrdersByArtIds(Collection<String> artIds) {
		return artAlbumRepository.mutiGetOrdersByArtIds(artIds);
	}
}
