package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ActivityArtRepository;
import com.jz.jooq.franchise.tables.pojos.ActivityArt;
import com.jz.jooq.franchise.tables.pojos.ActivityArtAward;
import com.jz.jooq.franchise.tables.pojos.ActivityArtOtherAuthor;
import com.jz.jooq.franchise.tables.pojos.ActivityArtThanks;
import com.jz.jooq.franchise.tables.pojos.ActivityOciTeamMember;

@Lazy
@Service
public class ActivityArtService {

	@Autowired
	private ActivityArtRepository activityArtRepository;

	public List<ActivityArt> getAllSimpleArtBySuid(String suid) {
		return activityArtRepository.getAllSimpleArtBySuid(suid);
	}

	public List<ActivityArt> getAllMatchArtBySuids(Collection<String> suids) {
		return activityArtRepository.getAllMatchArtBySuids(suids);
	}

	public ActivityArt getOnlineArtByArtId(String id) {
		return activityArtRepository.getOnlineArtByArtId(id);
	}

	public List<ActivityArt> mutiGetOnlineMatchArtByArtIds(Collection<String> artIds) {
		return activityArtRepository.mutiGetOnlineMatchArtByArtIds(artIds);
	}

	public List<ActivityArtAward> getArtAwardsByArtIds(Collection<String> artIds) {
		return activityArtRepository.getArtAwardsByArtIds(artIds);
	}

	public ActivityArtAward getArtAwardsByArtId(String artId) {
		return activityArtRepository.getArtAwardsByArtId(artId);
	}

	public List<ActivityArtOtherAuthor> getOtherAuthorBySuid(String suid) {
		return activityArtRepository.getOtherAuthorBySuid(suid);
	}

	public List<String> getOtherAuthorArtIdsBySuids(Collection<String> suids) {
		return activityArtRepository.getOtherAuthorArtIdsBySuids(suids);
	}

	public List<ActivityArtThanks> getArtThanksBySuid(String suid) {
		return activityArtRepository.getArtThanksBySuid(suid);
	}

	public List<ActivityOciTeamMember> getOciTeamMembersBySuid(String suid) {
		return activityArtRepository.getOciTeamMembersBySuid(suid);
	}

	public Map<String, String> mutiGetOciTeamId2CertNameMap(Collection<String> teamIds) {
		return activityArtRepository.mutiGetOciTeamId2CertNameMap(teamIds);
	}

	public String getOciCertNameByTeamId(String teamId) {
		return activityArtRepository.getOciCertNameByTeamId(teamId);
	}
}
