package com.jz.jar.franchise.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ActivityHoRepository;
import com.jz.jooq.franchise.tables.pojos.ActivityHo;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateArtCommon;

@Lazy
@Service
public class ActivityHoService {

	@Autowired
	private ActivityHoRepository activityHoRepository;

	public int countOnlineActivities(String brandId) {
		return activityHoRepository.countOnlineActivities(brandId);
	}

	public List<ActivityHo> findAllOnlineActivities(String brandId, int start, int size) {
		return activityHoRepository.findAllOnlineActivities(brandId, start, size);
	}

	public Map<String, String> mutiGetActivityId2NameMap(Collection<String> activityIds) {
		return activityHoRepository.mutiGetActivityId2NameMap(activityIds);
	}

	public String getActivityName(String activityId) {
		return activityHoRepository.getActivityName(activityId);
	}

	public List<ActivityTemplateArtCommon> getPublishExcludeNoStartTemplate(String brandId, int size) {
		return activityHoRepository.getPublishExcludeNoStartTemplate(brandId, size);
	}

	public List<ActivityTemplateArtCommon> getCurrentPublishTemplate(String brandId, int size) {
		return activityHoRepository.getCurrentPublishTemplate(brandId, size);
	}

	public boolean existCurrentPublishAllowWorksTemplate(String brandId) {
		return activityHoRepository.existCurrentPublishAllowWorksTemplate(brandId);
	}

	public Map<String, BigDecimal> mutiGetActivityIdPaperCertFee(Collection<String> activityIds) {
		return activityHoRepository.mutiGetActivityIdPaperCertFee(activityIds);
	}

	public BigDecimal getPaperCertFee(String activityId) {
		return activityHoRepository.getPaperCertFee(activityId);
	}
}
