package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ArtAlbumInfo;
import com.jz.jooq.franchise.tables.pojos.ArtAlbumOrder;

/**
 * 画册
 */
@Lazy
@Repository
public class ArtAlbumRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ArtAlbumInfo AAI = Tables.ART_ALBUM_INFO;
	private static final com.jz.jooq.franchise.tables.ArtAlbumOrder AAO = Tables.ART_ALBUM_ORDER;

	/** ArtAlbumInfo **/
	public ArtAlbumInfo getInfo(String albumId) {
		return franchiseCtx.selectFrom(AAI).where(AAI.ALBUM_ID.eq(albumId)).fetchAnyInto(ArtAlbumInfo.class);
	}

	public List<ArtAlbumInfo> mutiGetInfos(Collection<String> albumIds) {
		return franchiseCtx.selectFrom(AAI).where(AAI.ALBUM_ID.in(albumIds)).fetchInto(ArtAlbumInfo.class);
	}

	/** ArtAlbumOrder **/
	public List<ArtAlbumOrder> mutiGetOrdersByArtIds(Collection<String> artIds) {
		return franchiseCtx.selectFrom(AAO).where(AAO.ART_ID.in(artIds).and(AAO.STATUS.eq(1)))
				.fetchInto(ArtAlbumOrder.class);
	}

}
