package com.jz.jar.franchise.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class AgeCalUtil {

	public static int getAge(String birthDayStr) {
		if (StringUtils.isEmpty(birthDayStr)) {
			return 0;
		}
		Date birthDay = null;
		try {
			birthDay = DateUtils.parseDate(birthDayStr, new String[] { "yyyy-MM-dd", "yyyy-MM", "yyyy" });
		} catch (ParseException e) {
			// logger.warn("unparse birthday:" + birthDayStr);
			return 0;
		}

		Calendar cal = Calendar.getInstance();

		if (cal.before(birthDay)) {
			return 0;
		}
		int yearNow = cal.get(Calendar.YEAR);
		int monthNow = cal.get(Calendar.MONTH);
		int dayOfMonthNow = cal.get(Calendar.DAY_OF_MONTH);
		cal.setTime(birthDay);

		int yearBirth = cal.get(Calendar.YEAR);
		int monthBirth = cal.get(Calendar.MONTH);
		int dayOfMonthBirth = cal.get(Calendar.DAY_OF_MONTH);

		int age = yearNow - yearBirth;

		if (monthNow <= monthBirth) {
			if (monthNow == monthBirth) {
				if (dayOfMonthNow < dayOfMonthBirth)
					age--;
			} else {
				age--;
			}
		}
		return age;
	}

}
