package com.jz.jar.franchise.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class AuditionUserRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.AuditionUser AU = Tables.AUDITION_USER;

	public boolean existAudition(String puid, String brandId) {
		return franchiseCtx.fetchExists(AU, AU.PUID.eq(puid).and(AU.BRAND_ID.eq(brandId)));
	}

	public void recordAudition(String puid, String brandId) {
		franchiseCtx.insertInto(AU, AU.PUID, AU.BRAND_ID, AU.CREATE_TIME)
				.values(puid, brandId, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

}
