package com.jz.jar.franchise.repository;

import java.util.List;

import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ActivityHo;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateArtCommon;

@Lazy
@Repository
public class ActivityHoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ActivityHo A = Tables.ACTIVITY_HO;
	private static final com.jz.jooq.franchise.tables.ActivityTemplateArtCommon ATAC = Tables.ACTIVITY_TEMPLATE_ART_COMMON;

	private Condition getWhereCondition(String brandId) {
		return A.BRAND_ID.eq(brandId).and(A.APPLY_STATUS.eq(1)).and(A.PIC.ne(""));
	}

	public int countOnlineActivities(String brandId) {
		return franchiseCtx.fetchCount(A, getWhereCondition(brandId));
	}

	public List<ActivityHo> findAllOnlineActivities(String brandId, int start, int size) {
		// CASE WHEN `start_time` < unix_timestamp(now())*1000 and `end_time` >
		// unix_timestamp(now())*1000 THEN 0
		// WHEN `start_time` > unix_timestamp(now())*1000 THEN 1 else 2 end
		long timeMillis = System.currentTimeMillis();
		Field<Integer> orderField = DSL.choose()
				.when(A.START_TIME.le(timeMillis).and(A.END_TIME.ge(timeMillis)), DSL.zero())
				.when(A.START_TIME.gt(timeMillis), DSL.one()).otherwise(DSL.two()).as("COT");
		return franchiseCtx.select(A.NAME, A.START_TIME, A.END_TIME, A.DESCRIPTION, A.PIC, A.DISPLAY_URL, orderField)
				.from(A).where(getWhereCondition(brandId)).orderBy(orderField.asc(), A.START_TIME.asc())
				.limit(start, size).fetchInto(ActivityHo.class);
	}

	public List<ActivityTemplateArtCommon> getPublishExcludeNoStartTemplate(String brandId, int size) {
		return franchiseCtx
				.selectFrom(ATAC)
				.where(ATAC.BRAND_ID.eq(brandId).and(ATAC.STATUS.eq(1))
						.and(ATAC.START_TIME.lt(System.currentTimeMillis()))).orderBy(ATAC.START_TIME.desc())
				.limit(size).fetchInto(ActivityTemplateArtCommon.class);
	}

	public boolean existCurrentPublishAllowWorksTemplate(String brandId) {
		long current = System.currentTimeMillis();
		return franchiseCtx.fetchExists(
				ATAC,
				ATAC.BRAND_ID.eq(brandId).and(ATAC.SIGN_END_TIME.gt(current)).and(ATAC.START_TIME.lt(current))
						.and(ATAC.STATUS.eq(1)).and(ATAC.ALLOW_WORKS.eq(1)));
	}
}
