package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CourseTomato;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class CourseTomatoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CourseTomato CT = Tables.COURSE_TOMATO;

	public List<CourseTomato> mutiGetCourses(String brandId, Collection<Integer> courseIds) {
		return franchiseCtx.selectFrom(CT).where(CT.BRAND_ID.eq(brandId).and(CT.COURSE_ID.in(courseIds)))
				.fetchInto(CourseTomato.class);
	}

	public String getCourseLevel(String brandId, int courseId) {
		return franchiseCtx.select(CT.LEVEL).from(CT).where(CT.BRAND_ID.eq(brandId).and(CT.COURSE_ID.eq(courseId)))
				.fetchAnyInto(String.class);
	}

}
