package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.SchoolRepository;
import com.jz.jooq.franchise.tables.pojos.School;

/**
 * @Title SchoolService
 * @Package com.jz.jar.franchise.service
 * @author tangjunfeng
 * @date 2018年8月28日 下午5:59:28
 * @version V1.0
 */
@Lazy
@Service
public class SchoolService {

	@Autowired
	private SchoolRepository schoolRepository;

	public School getSchool(String id) {
		return schoolRepository.getSchool(id);
	}

	public School getSimpleSchool(String id) {
		return schoolRepository.getSimpleSchool(id);
	}

	public List<School> getSimpleSchool(Collection<String> ids) {
		return schoolRepository.getSimpleSchool(ids);
	}

	/** city_level字段用作表示学校数量（不想添加字段） */
	public List<School> getSchoolAreas(String brand, boolean isReservation, boolean isWeb) {
		return schoolRepository.getSchoolAreas(brand, isReservation, isWeb);
	}

	public List<School> getSchools(String brand, String prov, String city, boolean isReservation, boolean isWeb) {
		return schoolRepository.getSchools(brand, prov, city, isReservation, isWeb);
	}

	public List<School> getSchoolForName(String brand, String schoolName, boolean isWeb) {
		return schoolRepository.getSchoolForName(brand, schoolName, isWeb);
	}

	public String getSchoolName(String id) {
		return schoolRepository.getSchoolName(id);
	}

	public List<String> getSchoolIdForBrand(String brand) {
		return schoolRepository.getSchoolIdForBrand(brand);
	}

	public Map<String, String> mutiGetId2NameMap(Collection<String> schoolIds) {
		return schoolRepository.mutiGetId2NameMap(schoolIds);
	}

	public List<String> filterSchoolIdByBrand(Collection<String> schoolIds, String brandId) {
		return schoolRepository.filterSchoolIdByBrand(schoolIds, brandId);
	}
}
