package com.jz.jar.franchise.repository;

import java.util.List;

import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CouponInfo;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class CouponInfoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CouponInfo CI = Tables.COUPON_INFO;

	public List<CouponInfo> getCouponsByPuid(String puid) {
		return franchiseCtx.selectFrom(CI).where(CI.PUID.eq(puid))
				.orderBy(DSL.choose().when(CI.STATUS.eq(0).and(CI.END_TIME.ge(System.currentTimeMillis())), 1)
						.otherwise(2).asc(), CI.CREATE_TIME.desc())
				.fetchInto(CouponInfo.class);
	}

	public CouponInfo getCouponByCode(String couponCode) {
		return franchiseCtx.selectFrom(CI).where(CI.COUPON_CODE.eq(couponCode)).fetchAnyInto(CouponInfo.class);
	}

	public void updateTransfer(String couponCode, String sourcePuid, String targetPuid) {
		franchiseCtx.update(CI).set(CI.PUID, targetPuid).set(CI.SOURCE_PUID, sourcePuid).set(CI.IS_TRANSFER, 1)
				.where(CI.COUPON_CODE.eq(couponCode)).execute();
	}
}
